/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.EndPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndSounds;
import org.betterx.betterend.registry.EndTags;
import org.jetbrains.annotations.NotNull;

public class EndBiome
extends BCLBiome
implements SurfaceMaterialProvider {
    public static final Codec<EndBiome> CODEC = RecordCodecBuilder.create(instance -> EndBiome.codecWithSettings((RecordCodecBuilder.Instance)instance, (RecordCodecBuilder)Codec.BOOL.fieldOf("has_caves").orElse((Object)true).forGetter(o -> o.hasCaves), (RecordCodecBuilder)SurfaceMaterialProvider.CODEC.fieldOf("surface").orElse((Object)Config.DEFAULT_MATERIAL).forGetter(o -> o.surfMatProv)).apply((Applicative)instance, EndBiome::new));
    public static final KeyDispatchDataCodec<EndBiome> KEY_CODEC = KeyDispatchDataCodec.m_216236_(CODEC);
    private boolean hasCaves = true;
    protected SurfaceMaterialProvider surfMatProv = Config.DEFAULT_MATERIAL;

    public KeyDispatchDataCodec<? extends BCLBiome> codec() {
        return KEY_CODEC;
    }

    protected EndBiome(float terrainHeight, float fogDensity, float genChance, int edgeSize, boolean vertical, Optional<ResourceLocation> edge, ResourceLocation biomeID, Optional<List<Climate.ParameterPoint>> parameterPoints, Optional<ResourceLocation> biomeParent, Optional<String> intendedType, boolean hasCaves, SurfaceMaterialProvider surface) {
        super(terrainHeight, fogDensity, genChance, edgeSize, vertical, edge, biomeID, parameterPoints, biomeParent, intendedType);
        this.hasCaves = hasCaves;
        this.surfMatProv = surface;
    }

    void setHasCaves(boolean v) {
        this.hasCaves = v;
    }

    public boolean hasCaves() {
        return this.hasCaves;
    }

    public EndBiome(ResourceKey<Biome> biomeID, BCLBiomeSettings settings) {
        super(biomeID, settings);
    }

    public static EndBiome create(Config biomeConfig, BiomeAPI.BiomeType type) {
        return EndBiome.create(biomeConfig, type, null);
    }

    public static EndBiome createSubBiome(Config data, @NotNull BCLBiome parentBiome) {
        return EndBiome.create(data, parentBiome.getIntendedType(), parentBiome);
    }

    private static EndBiome create(Config biomeConfig, BiomeAPI.BiomeType type, BCLBiome parentBiome) {
        BCLBiomeBuilder builder = BCLBiomeBuilder.start((ResourceLocation)biomeConfig.ID).music((Holder)SoundEvents.f_12151_).waterColor(BCLBiomeBuilder.DEFAULT_END_WATER_COLOR).waterFogColor(BCLBiomeBuilder.DEFAULT_END_WATER_FOG_COLOR).fogColor(BCLBiomeBuilder.DEFAULT_END_FOG_COLOR).skyColor(BCLBiomeBuilder.DEFAULT_END_SKY_COLOR).mood(EndSounds.AMBIENT_DUST_WASTELANDS).temperature(BCLBiomeBuilder.DEFAULT_END_TEMPERATURE).wetness(BCLBiomeBuilder.DEFAULT_END_WETNESS).parentBiome(parentBiome).precipitation(Biome.Precipitation.NONE).surface(biomeConfig.surfaceMaterial().surface().build()).type(type);
        biomeConfig.addCustomBuildData(builder);
        EndFeatures.addDefaultFeatures(biomeConfig.ID, builder, biomeConfig.hasCaves());
        if (biomeConfig.hasReturnGateway()) {
            builder.feature(GenerationStep.Decoration.SURFACE_STRUCTURES, EndPlacements.f_195255_);
        }
        EndBiome biome = (EndBiome)builder.build(biomeConfig.getSupplier()).biome();
        biome.setHasCaves(biomeConfig.hasCaves());
        biome.setSurfaceMaterial(biomeConfig.surfaceMaterial());
        EndTags.addBiomeSurfaceToEndGroup(biome);
        return biome;
    }

    protected void setSurfaceMaterial(SurfaceMaterialProvider prov) {
        this.surfMatProv = prov;
    }

    public BlockState getTopMaterial() {
        return this.surfMatProv.getTopMaterial();
    }

    public BlockState getUnderMaterial() {
        return this.surfMatProv.getUnderMaterial();
    }

    public BlockState getAltTopMaterial() {
        return this.surfMatProv.getAltTopMaterial();
    }

    public boolean generateFloorRule() {
        return this.surfMatProv.generateFloorRule();
    }

    public SurfaceRuleBuilder surface() {
        return this.surfMatProv.surface();
    }

    public static BlockState findTopMaterial(BCLBiome biome) {
        return BiomeAPI.findTopMaterial((BCLBiome)biome).orElse(Config.DEFAULT_MATERIAL.getTopMaterial());
    }

    public static BlockState findTopMaterial(Biome biome) {
        return EndBiome.findTopMaterial(BiomeAPI.getBiome((Biome)biome));
    }

    public static BlockState findTopMaterial(WorldGenLevel world, BlockPos pos) {
        return EndBiome.findTopMaterial(BiomeAPI.getBiome((Holder)world.m_204166_(pos)));
    }

    public static BlockState findUnderMaterial(BCLBiome biome) {
        return BiomeAPI.findUnderMaterial((BCLBiome)biome).orElse(Config.DEFAULT_MATERIAL.getUnderMaterial());
    }

    public static BlockState findUnderMaterial(WorldGenLevel world, BlockPos pos) {
        return EndBiome.findUnderMaterial(BiomeAPI.getBiome((Holder)world.m_204166_(pos)));
    }

    public static List<BCLBiome> getAllBeBiomes() {
        return BiomeAPI.getAllBiomes((BiomeAPI.BiomeType)BiomeAPI.BiomeType.END);
    }

    public static abstract class Config {
        public static final SurfaceMaterialProvider DEFAULT_MATERIAL = new DefaultSurfaceMaterialProvider();
        protected static final SurfaceRules.RuleSource END_STONE = SurfaceRules.m_189390_((BlockState)DefaultSurfaceMaterialProvider.END_STONE);
        protected static final SurfaceRules.RuleSource END_MOSS = SurfaceRules.m_189390_((BlockState)EndBlocks.END_MOSS.m_49966_());
        protected static final SurfaceRules.RuleSource ENDSTONE_DUST = SurfaceRules.m_189390_((BlockState)EndBlocks.ENDSTONE_DUST.m_49966_());
        protected static final SurfaceRules.RuleSource END_MYCELIUM = SurfaceRules.m_189390_((BlockState)EndBlocks.END_MYCELIUM.m_49966_());
        protected static final SurfaceRules.RuleSource FLAVOLITE = SurfaceRules.m_189390_((BlockState)EndBlocks.FLAVOLITE.stone.m_49966_());
        protected static final SurfaceRules.RuleSource SULPHURIC_ROCK = SurfaceRules.m_189390_((BlockState)EndBlocks.SULPHURIC_ROCK.stone.m_49966_());
        protected static final SurfaceRules.RuleSource BRIMSTONE = SurfaceRules.m_189390_((BlockState)EndBlocks.BRIMSTONE.m_49966_());
        protected static final SurfaceRules.RuleSource PALLIDIUM_FULL = SurfaceRules.m_189390_((BlockState)EndBlocks.PALLIDIUM_FULL.m_49966_());
        protected static final SurfaceRules.RuleSource PALLIDIUM_HEAVY = SurfaceRules.m_189390_((BlockState)EndBlocks.PALLIDIUM_HEAVY.m_49966_());
        protected static final SurfaceRules.RuleSource PALLIDIUM_THIN = SurfaceRules.m_189390_((BlockState)EndBlocks.PALLIDIUM_THIN.m_49966_());
        protected static final SurfaceRules.RuleSource PALLIDIUM_TINY = SurfaceRules.m_189390_((BlockState)EndBlocks.PALLIDIUM_TINY.m_49966_());
        protected static final SurfaceRules.RuleSource UMBRALITH = SurfaceRules.m_189390_((BlockState)EndBlocks.UMBRALITH.stone.m_49966_());
        public final ResourceLocation ID;

        protected Config(String name) {
            this.ID = BetterEnd.makeID(name);
        }

        protected Config(ResourceLocation ID) {
            this.ID = ID;
        }

        protected abstract void addCustomBuildData(BCLBiomeBuilder var1);

        public BCLBiomeBuilder.BiomeSupplier<EndBiome> getSupplier() {
            return EndBiome::new;
        }

        protected boolean hasCaves() {
            return true;
        }

        protected boolean hasReturnGateway() {
            return true;
        }

        protected SurfaceMaterialProvider surfaceMaterial() {
            return DEFAULT_MATERIAL;
        }
    }

    public static class DefaultSurfaceMaterialProvider
    implements SurfaceMaterialProvider {
        public static final BlockState END_STONE = Blocks.f_50259_.m_49966_();

        public BlockState getTopMaterial() {
            return this.getUnderMaterial();
        }

        public BlockState getAltTopMaterial() {
            return this.getTopMaterial();
        }

        public BlockState getUnderMaterial() {
            return END_STONE;
        }

        public boolean generateFloorRule() {
            return true;
        }

        public SurfaceRuleBuilder surface() {
            SurfaceRuleBuilder builder = SurfaceRuleBuilder.start();
            if (this.generateFloorRule() && this.getTopMaterial() != this.getUnderMaterial()) {
                if (this.getTopMaterial() != this.getAltTopMaterial()) {
                    builder.floor(this.getTopMaterial());
                } else {
                    builder.chancedFloor(this.getTopMaterial(), this.getAltTopMaterial());
                }
            }
            return builder.filler(this.getUnderMaterial());
        }
    }
}

